qui {

noi {
	/*************************************************/
	/***** Step 2.4.2. Full sample estimation	    **/
	/*************************************************/
}

	* STEP 1. Compute NIC-specific independence dividends and RMSPE for each robustness check
	noi di ""
	noi di "Compute alterentive independence dividend estimates"
	noi di ""
	noi di ""
	
		* Robustness check 1
		noi di "ROBUSTNESS CHECK 1"
		noi di ""
		local j = 0
		cd ..
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -10
			local stop_RMSPE = -1
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD_R1_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo_R1_`cntry'.dta
				cap erase Placebo_R1_`cntry'.dta
				forval l=1/500 {
					cap erase placebo_R1_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. Robustness check 1\3.1.1.1. Weights"
				cap use cntry_weights1_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
							cd ..
							cd ..
							cd ..
							cd ..
							restore
							noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
		
				if `r(N)' > 0 {
					if `r(min)' < 0 { 
							cd ..
							cd ..
							cd ..
							cd ..
							restore
							noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
					if `r(min)' >= 0 {
					cd ..
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
								
					* Load master data
					clear all
					cd ".\4. Master data"
					use master_data.dta, clear 
					cd ..
					
					* Generate necessary variables
					gen IDD = .
					gen rmspe = .
					gen oosrmspe = .
						
					* Label variables
					label var IDD "Raw independence dividend estimate"
					label var rmspe "Root Mean Square Prediction Error"
					label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
								
					/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

						* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence_dividends
						 gen synth_gdpcap_`cntry' = .
						 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"
						 
						* 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
						preserve
						cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. Robustness check 1\3.1.1.1. Weights"
						use cntry_weights1_`cntry'.dta, clear
						gen cntrycode = _Co_Number
						gen weight_`cntry' = _W_Weight
						keep cntrycode weight_`cntry'
						save weights_R1_`cntry', replace
						restore
						
						* 1.3. Add them to the existing data
						merge m:1 cntrycode using weights_R1_`cntry'		// Collect weights for synthetic country associated with each NIC
						drop _*
						erase weights_R1_`cntry'.dta
						cd ..
						cd ..
						cd ..
						cd ..
						
						* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
						gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
						sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
						local yoi = r(mean)
						sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
						local componentparts = r(N)
									
						foreach year of numlist $startyear / 2016 {
							sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
							replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
							}	
							
						* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
						levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= sample of potential control countries)
									
						local i = 1
								
						cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.3. Robustness check 1\3.2.1. Weights"
						foreach placebocntry of local placebo_countries {
											
								di `placebocntry', _continue
								
								* Collect the weights for the counterfactual country for each potential control country
								preserve
								cap use cntry_weights1_`cntry'_`i'.dta, clear
								if _rc == 0 {
									cap gen cntrycode = _Co_Number
									if _rc == 0 {
										gen weight_`cntry'_`placebocntry' = _W_Weight
										keep cntrycode weight_`cntry'_`placebocntry'
										save weights_R1_`cntry'_`i', replace
										restore
													
										* Add it to the existing data
										merge m:1 cntrycode using weights_R1_`cntry'_`i'	// Collect weights for synthetic country associated with each placebo
										drop _*
													
										* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
										gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
										sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
										local componentparts = r(N)
										
										foreach year of numlist $startyear / 2016 {
											sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
											replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
											}	
														
										* Erase obsolete data
										erase weights_R1_`cntry'_`i'.dta
										}
									else if _rc != 0 {
										restore
										}
									}
								else if _rc != 0 {
									restore
									}
								local i = `i' + 1
								}
						cd ..
						cd ..
						cd ..
						cd ..
						
					/* PART 2: estimate independence dividends + RMSPE */

						* 2.1. Independence dividend
						gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
						gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
						gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
						replace IDD = lgap_`cntry' if cntrycode == `cntry'
						
						* 2.2. Root Mean Squared Prediction Error (RMSPE)
						levelsof cntrycode if lgap_`cntry' != ., local(placebo_countries)
						foreach placebocntry of local placebo_countries {
							scalar SPE_`placebocntry' = 0
							scalar total_observations_`placebocntry' = 0
							foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
								sum year if cntrycode == `cntry' & independence_years == `year' & year > $startyear
								if `r(N)' != 0 {
									sum lgap_`cntry' if cntrycode == `placebocntry' & year == `r(mean)'
									if r(mean) != . {
										scalar SPE_`placebocntry' = SPE_`placebocntry' + (r(mean)^2)
										scalar total_observations_`placebocntry' = total_observations_`placebocntry' + 1
										}
									}
								}
							scalar MSPE_`placebocntry' = SPE_`placebocntry'/total_observations_`placebocntry'
							scalar RMSPE_`placebocntry' = sqrt(MSPE_`placebocntry')
							replace rmspe = RMSPE_`placebocntry' if cntrycode == `placebocntry'
							}
							
						* 2.3. Trend-demeaned independence dividends
						gen bc_lgap_`cntry' = .
						levelsof cntrycode if lgap_`cntry' != ., local(countries)
						sum year if independence_years == -10 & cntrycode == `cntry'
						cap local year_1 = `r(mean)'
						if _rc != 0 {
							local year_1 = $startyear
							}
						sum year if independence_years == -1 & cntrycode == `cntry'
						local year_2 = `r(mean)'
						
						foreach CNTRY in `countries' {
							sum lgap_`cntry' if year >= `year_1' & year <= `year_2' & cntrycode == `CNTRY'
							replace bc_lgap_`cntry' = lgap_`cntry'-`r(mean)' if cntrycode == `CNTRY'
							}
						gen TDIDD = bc_lgap_`cntry' if cntrycode == `cntry'
													
						* Drop unnecesaries
						drop weight*
						
						* Save estimates for this NIC
						
							* NIC-specific results
							preserve
							keep cntrycode cntry independence_years IDD TDIDD rmspe year baseline_lgdpcap synth_lgdpcap popshare
							drop if cntrycode != `cntry'
							drop if IDD == .
							sum independence_years if cntrycode == `cntry'
							if `r(N)' != 0 {
								local min = max(-15,`r(min)')
								sum year if cntrycode == `cntry' & independence_years == `min'
								drop if year < `r(mean)'
								sort cntrycode independence_years
								cd ".\3. Intermediary results\3.4. Intermediaries"
								save IDD_R1_`cntry', replace
								cd ..
								cd ..
								}
							restore
							
							* Including placebo results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry' bc_lgap_`cntry' popshare
							drop if independence_years == .
							drop if lgap_`cntry' == .
							if `r(N)' != 0 {
								sum independence_years if cntrycode == `cntry'
								local min = max(-15,`r(min)')
								sum year if cntrycode == `cntry' & independence_years == `min'
								drop if year < `r(mean)'
								sort cntrycode independence_years
								cd ".\3. Intermediary results\3.4. Intermediaries"
								save PIDD_R1_`cntry', replace
								cd ..
								cd ..
								}
							restore
						}
						}
					}
				}
			}
		
		* Robustness check 2
		noi di ""
		noi di ""
		noi di "ROBUSTNESS CHECK 2"
		noi di ""
		use ".\4. Master data\master_data.dta", clear
		local j = 0
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -15
			local stop_RMSPE = -6
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD_R2_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo_R2_`cntry'.dta
				cap erase Placebo_R2_`cntry'.dta
				forval l=1/500 {
					cap erase placebo_R2_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 2\3.1.1.1. Weights"
				cap use cntry_weights1_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
						cd ..
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
					if `r(N)' > 0 {
						cd ..
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
									
						* Load master data
						clear all
						cd ".\4. Master data"
						use master_data.dta, clear 
						cd ..
						
						* Generate necessary variables
						gen IDD = .
						gen rmspe = .
						gen oosrmspe = .
							
						* Label variables
						label var IDD "Raw independence dividend estimate"
						label var rmspe "Root Mean Square Prediction Error"
						label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
									
						/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

							* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence_dividends
							 gen synth_gdpcap_`cntry' = .
							 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"

							 * 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
							preserve
							cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 2\3.1.1.1. Weights"
							use cntry_weights1_`cntry'.dta, clear
							gen cntrycode = _Co_Number
							gen weight_`cntry' = _W_Weight
							keep cntrycode weight_`cntry'
							save weights_R2_`cntry', replace
							restore
							
							* 1.3. Add them to the existing data
							merge m:1 cntrycode using weights_R2_`cntry'		// Collect weights for synthetic country associated with each NIC
							drop _*
							erase weights_R2_`cntry'.dta
							cd ..
							cd ..
							cd ..
							cd ..
							
							* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
							gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
							sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
							local yoi = r(mean)
							sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
							local componentparts = r(N)
										
							foreach year of numlist $startyear / 2016 {
								sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
								replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
								}	
								
							* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
							levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= potential control countries)
										
							local i = 1
									
							cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.3. robustness check 2\3.2.1. Weights"
							foreach placebocntry of local placebo_countries {
												
									di `placebocntry', _continue
									
									* Collect the weights for the counterfactual country for each potential control country
									preserve
									cap use cntry_weights1_`cntry'_`i'.dta, clear
									if _rc == 0 {
										cap gen cntrycode = _Co_Number
										if _rc == 0 {
											gen weight_`cntry'_`placebocntry' = _W_Weight
											keep cntrycode weight_`cntry'_`placebocntry'
											save weights_R2_`cntry'_`i', replace
											restore
														
											* Add it to the existing data
											merge m:1 cntrycode using weights_R2_`cntry'_`i'	// Collect weights for synthetic country associated with each placebo
											drop _*
														
											* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
											gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
											sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
											local componentparts = r(N)
											
											foreach year of numlist $startyear / 2016 {
												sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
												replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
												}	
															
											* Erase obsolete data
											erase weights_R2_`cntry'_`i'.dta
											}
										else if _rc != 0 {
											restore
											}
										}
									else if _rc != 0 {
										restore
										}
									local i = `i' + 1
									}
							cd ..
							cd ..
							cd ..
							cd ..
							
						/* PART 2: estimate independence dividends + RMSPE */

							* 2.1. Independence dividend
							gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
							gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
							gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
							replace IDD = lgap_`cntry' if cntrycode == `cntry'
							
							* 2.2. Root Mean Squared Prediction Error (RMSPE)
							levelsof cntrycode if lgap_`cntry' != ., local(placebo_countries)
							foreach placebocntry of local placebo_countries {
								scalar SPE_`placebocntry' = 0
								scalar total_observations_`placebocntry' = 0
								foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
									sum year if cntrycode == `cntry' & independence_years == `year' & year > $startyear
									if `r(N)' != 0 {
										sum lgap_`cntry' if cntrycode == `placebocntry' & year == `r(mean)'
										if r(mean) != . {
											scalar SPE_`placebocntry' = SPE_`placebocntry' + (r(mean)^2)
											scalar total_observations_`placebocntry' = total_observations_`placebocntry' + 1
											}
										}
									}
								scalar MSPE_`placebocntry' = SPE_`placebocntry'/total_observations_`placebocntry'
								scalar RMSPE_`placebocntry' = sqrt(MSPE_`placebocntry')
								replace rmspe = RMSPE_`placebocntry' if cntrycode == `placebocntry'
								}
					
							* 2.3. Trend-demeaned independence dividends
							gen bc_lgap_`cntry' = .
							levelsof cntrycode if lgap_`cntry' != ., local(countries)
							sum year if independence_years == -10 & cntrycode == `cntry'
							cap local year_1 = `r(mean)'
							if _rc != 0 {
								local year_1 = $startyear
								}
							sum year if independence_years == -1 & cntrycode == `cntry'
							local year_2 = `r(mean)'
							
							foreach CNTRY in `countries' {
								sum lgap_`cntry' if year >= `year_1' & year <= `year_2' & cntrycode == `CNTRY'
								replace bc_lgap_`cntry' = lgap_`cntry'-`r(mean)' if cntrycode == `CNTRY'
								}
							gen TDIDD = bc_lgap_`cntry' if cntrycode == `cntry'
														
							* Drop unnecesaries
							drop weight*
							
							* Save estimates for this NIC
							
								* NIC-specific results
								preserve
								keep cntrycode cntry independence_years IDD TDIDD rmspe year baseline_lgdpcap synth_lgdpcap popshare
								drop if cntrycode != `cntry'
								drop if IDD == .
								sum independence_years if cntrycode == `cntry'
								if `r(N)' != 0 {
									local min = max(-15,`r(min)')
									sum year if cntrycode == `cntry' & independence_years == `min'
									drop if year < `r(mean)'
									sort cntrycode independence_years
									cd ".\3. Intermediary results\3.4. Intermediaries"
									save IDD_R2_`cntry', replace
									cd ..
									cd ..
									}
								restore
								
								* Including placebo results
								preserve
								keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry' bc_lgap_`cntry' popshare
								drop if independence_years == .
								drop if lgap_`cntry' == .
								sum independence_years if cntrycode == `cntry'
								if `r(N)' != 0 {
									local min = max(-15,`r(min)')
									sum year if cntrycode == `cntry' & independence_years == `min'
									drop if year < `r(mean)'
									sort cntrycode independence_years
									cd ".\3. Intermediary results\3.4. Intermediaries"
									save PIDD_R2_`cntry', replace
									cd ..
									cd ..
									}
								restore
							}
						}
					}
				}
	
		* Robustness check 3
		noi di ""
		noi di ""
		noi di "ROBUSTNESS CHECK 3"
		noi di ""
		use ".\4. Master data\master_data.dta", clear
		local j = 0
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -10
			local stop_RMSPE = -1
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD_R3_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo_R3_`cntry'.dta
				cap erase Placebo_R3_`cntry'.dta
				forval l=1/500 {
					cap erase placebo_R3_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 3\3.1.1.1. Weights"
				cap use cntry_weights1_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
						cd ..
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
				if `r(N)' > 0 {
					cd ..
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
								
					* Load master data
					clear all
					cd ".\4. Master data"
					use master_data.dta, clear 
					cd ..
					
					* Generate necessary variables
					gen IDD = .
					gen rmspe = .
					gen oosrmspe = .
						
					* Label variables
					label var IDD "Raw independence dividend estimate"
					label var rmspe "Root Mean Square Prediction Error"
					label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
								
					/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

						* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence_dividends
						 gen synth_gdpcap_`cntry' = .
						 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"
						 
						* 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
						preserve
						cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 3\3.1.1.1. Weights"
						use cntry_weights1_`cntry'.dta, clear
						gen cntrycode = _Co_Number
						gen weight_`cntry' = _W_Weight
						keep cntrycode weight_`cntry'
						save weights_R3_`cntry', replace
						restore
						
						* 1.3. Add them to the existing data
						merge m:1 cntrycode using weights_R3_`cntry'		// Collect weights for synthetic country associated with each NIC
						drop _*
						erase weights_R3_`cntry'.dta
						cd ..
						cd ..
						cd ..
						cd ..
						
						* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
						gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
						sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
						local yoi = r(mean)
						sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
						local componentparts = r(N)
									
						foreach year of numlist $startyear / 2016 {
							sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
							replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
							}	
							
						* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
						levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= potential control countries)
									
						local i = 1
								
						cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.3. robustness check 3\3.2.1. Weights"
						foreach placebocntry of local placebo_countries {
											
								di `placebocntry', _continue
								
								* Collect the weights for the counterfactual country for each potential control country
								preserve
								cap use cntry_weights1_`cntry'_`i'.dta, clear
								if _rc == 0 {
									cap gen cntrycode = _Co_Number
									if _rc == 0 {
										gen weight_`cntry'_`placebocntry' = _W_Weight
										keep cntrycode weight_`cntry'_`placebocntry'
										save weights_R3_`cntry'_`i', replace
										restore
													
										* Add it to the existing data
										merge m:1 cntrycode using weights_R3_`cntry'_`i'	// Collect weights for synthetic country associated with each NIC
										drop _*
													
										* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
										gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
										sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
										local componentparts = r(N)
										
										foreach year of numlist $startyear / 2016 {
											sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
											replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
											}	
														
										* Erase obsolete data
										erase weights_R3_`cntry'_`i'.dta
										}
									else if _rc != 0 {
										restore
										}
									}
								else if _rc != 0 {
									restore
									}
								local i = `i' + 1
								}
						cd ..
						cd ..
						cd ..
						cd ..
						
					/* PART 2: estimate independence dividends + RMSPE */

						* 2.1. Independence dividend
						gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
						gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
						gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
						replace IDD = lgap_`cntry' if cntrycode == `cntry'
						
						* 2.2. Root Mean Squared Prediction Error (RMSPE)
						levelsof cntrycode if lgap_`cntry' != ., local(placebo_countries)
						foreach placebocntry of local placebo_countries {
							scalar SPE_`placebocntry' = 0
							scalar total_observations_`placebocntry' = 0
							foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
								sum year if cntrycode == `cntry' & independence_years == `year' & year > $startyear
								if `r(N)' != 0 {
									sum lgap_`cntry' if cntrycode == `placebocntry' & year == `r(mean)'
									if r(mean) != . {
										scalar SPE_`placebocntry' = SPE_`placebocntry' + (r(mean)^2)
										scalar total_observations_`placebocntry' = total_observations_`placebocntry' + 1
										}
									}
								}
							scalar MSPE_`placebocntry' = SPE_`placebocntry'/total_observations_`placebocntry'
							scalar RMSPE_`placebocntry' = sqrt(MSPE_`placebocntry')
							replace rmspe = RMSPE_`placebocntry' if cntrycode == `placebocntry'
							}
							
						* 2.3. Trend-demeaned independence dividends
						gen bc_lgap_`cntry' = .
						levelsof cntrycode if lgap_`cntry' != ., local(countries)
						sum year if independence_years == -10 & cntrycode == `cntry'
						cap local year_1 = `r(mean)'
						if _rc != 0 {
							local year_1 = $startyear
							}
						sum year if independence_years == -1 & cntrycode == `cntry'
						local year_2 = `r(mean)'
						
						foreach CNTRY in `countries' {
							sum lgap_`cntry' if year >= `year_1' & year <= `year_2' & cntrycode == `CNTRY'
							replace bc_lgap_`cntry' = lgap_`cntry'-`r(mean)' if cntrycode == `CNTRY'
							}
						gen TDIDD = bc_lgap_`cntry' if cntrycode == `cntry'
						
						* Drop unnecesaries
						drop weight*
						
						* Save estimates for this NIC
						
							* NIC-specific results
							preserve
							keep cntrycode cntry independence_years IDD TDIDD rmspe year baseline_lgdpcap synth_lgdpcap popshare
							drop if cntrycode != `cntry'
							drop if IDD == .
							sum independence_years if cntrycode == `cntry'
							if `r(N)' != 0 {
								local min = max(-15,`r(min)')
								sum year if cntrycode == `cntry' & independence_years == `min'
								drop if year < `r(mean)'
								sort cntrycode independence_years
								cd ".\3. Intermediary results\3.4. Intermediaries"
								save IDD_R3_`cntry', replace
								cd ..
								cd ..
								}
							restore
							
							* Including placebo results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry' bc_lgap_`cntry' popshare
							drop if independence_years == .
							drop if lgap_`cntry' == .
							sum independence_years if cntrycode == `cntry'
							if `r(N)' != 0 {
								local min = max(-15,`r(min)')
								sum year if cntrycode == `cntry' & independence_years == `min'
								drop if year < `r(mean)'
								sort cntrycode independence_years
								cd ".\3. Intermediary results\3.4. Intermediaries"
								save PIDD_R3_`cntry', replace
								cd ..
								cd ..
								}
							restore
						}
					}
				}
			}
		
	
		* Robustness check 4
		noi di ""
		noi di ""
		noi di "ROBUSTNESS CHECK 4"
		noi di ""
		local j = 0
		foreach cntry of global NICs {
			
			*Report progress
			local j = `j'+1
			
			* Identify estimation window, for computation of RMSPE
			local identifier = "_10_"
			local start_RMSPE = -15
			local stop_RMSPE = -6
			
			* Check whether dividends still need to be computed
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap confirm file IDD2_`cntry'.dta
			if _rc == 0 {
				preserve
				cd ..
				cd ..
				cd "./4. Master data"
				use master_data, clear
				keep if cntrycode == `cntry'
				noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
				cd ..
				restore
				}
			else if _rc != 0 {
					
				* Erase potential leftover files from previous rounds
				cd ..
				cd ..
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap erase placebo2_`cntry'.dta
				cap erase Placebo2_`cntry'.dta
				forval l=1/500 {
					cap erase placebo2_`cntry'_`l'.dta
					}
				cd ..
				cd ..
				
				preserve
				cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
				cap use cntry_weights2_`cntry', clear
				cap sum _W_Weight
				if _rc != 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
					}
				else if _rc == 0 {
					if `r(N)' == 0 {
						cd ..
						cd ..
						cd ..
						restore
						noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry' unavailable)"
						}
				if `r(N)' > 0 {
					cd ..
					cd ..
					cd ..
					restore
					noisily di "Independence dividend estimation: newly independent cntry `j'/$totalNICs (cntrycode = `cntry')"
								
					* Load master data
					clear all
					cd ".\4. Master data"
					use master_data.dta, clear 
					cd ..
					
					* Generate necessary variables
					gen IDD = .
					gen rmspe = .
					gen oosrmspe = .
						
					* Label variables
					label var IDD "Raw independence dividend estimate"
					label var rmspe "Root Mean Square Prediction Error"
					label var oosrmspe "Out-of-Sample Root Mean Square Prediction Error"
								
					/* PART 1: collect the weights to construct synthetic versions of the NICs and their pool of potential control countries */

						* 1.1. Generate variable that will collect, for each NIC, the estimated (placebo) independence_dividends
						 gen synth_gdpcap_`cntry' = .
						 label var synth_gdpcap_`cntry' "Counterfactual per capita GDP (in absence of state fragmentation)"
						 
						* 1.2. Collect the weights for the counterfactual country for each NIC (as assigned by the synthetic control algorithm)
						preserve
						cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
						use cntry_weights2_`cntry'.dta, clear
						gen cntrycode = _Co_Number
						gen weight_`cntry' = _W_Weight
						keep cntrycode weight_`cntry'
						save weights2_`cntry', replace
						restore
						
						* 1.3. Add them to the existing data
						merge m:1 cntrycode using weights2_`cntry'		// Collect weights for synthetic country associated with each NIC
						drop _*
						erase weights2_`cntry'.dta
						cd ..
						cd ..
						cd ..
						
						* 1.4. Construct synthetic per capita GDP trajectory for each NIC, using the weights defined by the synthetic control algorithm							
						gen weighted_gdpcap_`cntry' = weight_`cntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
						sum year if cntrycode == `cntry' & independence_years == 0 & year >= $startyear
						local yoi = r(mean)
						sum weight_`cntry' if year == `yoi' & weight_`cntry' != 0
						local componentparts = r(N)
									
						foreach year of numlist $startyear / 2016 {
							sum weighted_gdpcap_`cntry' if year == `year' & weighted_gdpcap_`cntry' != 0 
							replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `cntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' & year > $startyear // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
							}	
							
						* 1.5. Collect the weights for the counterfactual country for each potential control country of this NIC (to construct placebo gaps)
						levelsof cntrycode if weight_`cntry' != ., local(placebo_countries)	// Creates a local containing all the country codes with non-missing (but potentially zero) weights, as assigned by the synthetic control algorithm (= potential control countries)
									
						local i = 1
								
						cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.1. Weights"
						foreach placebocntry of local placebo_countries {
											
								di `placebocntry', _continue
								
								* Collect the weights for the counterfactual country for each potential control country
								preserve
								cap use cntry_weights2_`cntry'_`i'.dta, clear
								if _rc == 0 {
									cap gen cntrycode = _Co_Number
									if _rc == 0 {
										gen weight_`cntry'_`placebocntry' = _W_Weight
										keep cntrycode weight_`cntry'_`placebocntry'
										save weights2_`cntry'_`i', replace
										restore
													
										* Add it to the existing data
										merge m:1 cntrycode using weights2_`cntry'_`i'	// Collect weights for synthetic country associated with each placebo
										drop _*
													
										* Construct synthetic per capita GDP trajectory for each placebo, using the weights defined by the synthetic control algorithm
										gen weighted_gdpcap_`cntry'_`placebocntry' = weight_`cntry'_`placebocntry' * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
										sum weight_`cntry'_`placebocntry' if year == `yoi' & weight_`cntry'_`placebocntry' != 0
										local componentparts = r(N)
										
										foreach year of numlist $startyear / 2016 {
											sum weighted_gdpcap_`cntry'_`placebocntry' if year == `year' & weighted_gdpcap_`cntry'_`placebocntry' != 0 
											replace synth_gdpcap_`cntry' = r(sum) if cntrycode == `placebocntry' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were determined by the SCM
											}	
														
										* Erase obsolete data
										erase weights2_`cntry'_`i'.dta
										}
									else if _rc != 0 {
										restore
										}
									}
								else if _rc != 0 {
									restore
									}
								local i = `i' + 1
								}
						cd ..
						cd ..
						cd ..
						
					/* PART 2: estimate independence dividends + RMSPE */

						* 2.1. Independence dividend
						gen synth_lgdpcap_`cntry' = ln(synth_gdpcap_`cntry')
						gen gap_`cntry' = baseline_gdpcap - synth_gdpcap_`cntry'
						gen lgap_`cntry' = baseline_lgdpcap - synth_lgdpcap_`cntry'
						replace IDD = lgap_`cntry' if cntrycode == `cntry'
						
						* 2.2. Root Mean Squared Prediction Error (RMSPE)
						levelsof cntrycode if lgap_`cntry' != ., local(placebo_countries)
						foreach placebocntry of local placebo_countries {
							scalar SPE_`placebocntry' = 0
							scalar total_observations_`placebocntry' = 0
							foreach year of numlist `start_RMSPE'/`stop_RMSPE' {
								sum year if cntrycode == `cntry' & independence_years == `year' & year > $startyear
								if `r(N)' != 0 {
									sum lgap_`cntry' if cntrycode == `placebocntry' & year == `r(mean)'
									if r(mean) != . {
										scalar SPE_`placebocntry' = SPE_`placebocntry' + (r(mean)^2)
										scalar total_observations_`placebocntry' = total_observations_`placebocntry' + 1
										}
									}
								}
							scalar MSPE_`placebocntry' = SPE_`placebocntry'/total_observations_`placebocntry'
							scalar RMSPE_`placebocntry' = sqrt(MSPE_`placebocntry')
							replace rmspe = RMSPE_`placebocntry' if cntrycode == `placebocntry'
							}
							
						* 2.3. Trend-demeaned independence dividends
						gen bc_lgap_`cntry' = .
						levelsof cntrycode if lgap_`cntry' != ., local(countries)
						sum year if independence_years == -10 & cntrycode == `cntry'
						cap local year_1 = `r(mean)'
						if _rc != 0 {
							local year_1 = $startyear
							}
						sum year if independence_years == -1 & cntrycode == `cntry'
						local year_2 = `r(mean)'
						
						foreach CNTRY in `countries' {
							sum lgap_`cntry' if year >= `year_1' & year <= `year_2' & cntrycode == `CNTRY'
							replace bc_lgap_`cntry' = lgap_`cntry'-`r(mean)' if cntrycode == `CNTRY'
							}
						gen TDIDD = bc_lgap_`cntry' if cntrycode == `cntry'
													
						* Drop unnecesaries
						drop weight*
						
						* Save estimates for this NIC
						
							* NIC-specific results
							preserve
							keep cntrycode cntry independence_years IDD TDIDD rmspe year baseline_lgdpcap synth_lgdpcap popshare
							drop if cntrycode != `cntry'
							drop if IDD == .
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save IDD2_`cntry', replace
							cd ..
							cd ..
							restore
							
							* Including placebo results
							preserve
							keep cntrycode cntry independence_years IDD rmspe year lgap_`cntry' bc_lgap_`cntry' popshare
							drop if independence_years == .
							drop if lgap_`cntry' == .
							sum independence_years if cntrycode == `cntry'
							local min = max(-15,`r(min)')
							sum year if cntrycode == `cntry' & independence_years == `min'
							drop if year < `r(mean)'
							sort cntrycode independence_years
							cd ".\3. Intermediary results\3.4. Intermediaries"
							save PIDD2_`cntry', replace
							cd ..
							cd ..
							restore
						}
					}
				}
			}
	
	* STEP 2. Compute aggregate independence dividends & confidence intervals for each case
		
		noi di ""
		noi di "Estimating bootstrapped confidence intervals for aggregate independence dividend estimates, iteration (/${firststepreps}):", _continue
		noi di ""
		foreach robustness_check of numlist 1/4 {
			noi di ""
			noi di "Robustness check `robustness_check', iteration (/${firststepreps}):", _continue
			if `robustness_check' == 1 {
				local identifier = "PIDD_R1_"
				}
			if `robustness_check' == 2 {
				local identifier = "PIDD_R2_"
				}
			if `robustness_check' == 3 {
				local identifier = "PIDD_R3_"
				}
			if `robustness_check' == 4 {
				local identifier = "PIDD2_"
				}
				
			* Load data
			foreach cntry of global NICs {
				
				di `cntry', _continue
				* Load raw estimates
				cd ".\3. Intermediary results\3.4. Intermediaries"
				cap use `identifier'`cntry', clear
				cd ..
				cd ..
				if _rc == 0 {
					
					sum cntrycode
					if `r(N)' != 0 {
					
						* Track progress
						di `cntry', _continue
						
						
						* Add population data
						cd "./4. Master data"
						merge 1:1 cntrycode year using master_data, keepusing(popshare)
						keep if _merge == 3
						drop _merge
						cd ..
						
						* Generate placebo-independence years
						gen pindependence_years = .
						foreach year of numlist $startyear / 2016 {
							sum independence_years if year == `year' & cntrycode == `cntry'
							cap replace pindependence_years = `r(mean)' if year == `year'
							}
								
						* generate placebo country codes
						gen pcntrycode = cntrycode if cntrycode == `cntry'
						replace pcntrycode = 1000*`cntry'+cntrycode if cntrycode != `cntry'
																	
						* Compute bias-corrected placebo-gaps
						levelsof cntrycode if lgap_`cntry' != ., local(countries)	
						cap gen bc_lgap_`cntry' = .
						if _rc == 0 {
							foreach cntry_2 in `countries' {
								sum lgap_`cntry' if pindependence_years >= -15 & pindependence_years <= -6 & cntrycode == `cntry_2'
								cap replace bc_lgap_`cntry' = lgap_`cntry'-`r(mean)' if cntrycode == `cntry_2'
								}
							}
						keep bc_lgap_`cntry' pindependence_years pcntrycode cntry popshare
						rename pindependence_years independence_years
						rename bc_lgap_`cntry' bc_lgap
						rename pcntrycode cntrycode
						
						* Collect estimated weights for each potential control country
						levelsof cntrycode if bc_lgap != ., local(countries)	
						
						* Generate country-codes & names
						egen placebocntrycode = group(cntrycode) if cntrycode != `cntry'

						replace placebocntrycode = `cntry'*1000+placebocntrycode
						replace placebocntrycode = `cntry' if cntrycode == `cntry'
						drop if independence_years == .
						drop cntrycode
						rename placebocntrycode cntrycode

						preserve
						keep if cntrycode == `cntry'
						local cname = cntry[1]
						restore
						
						egen helpme = group(cntrycode) if cntrycode != `cntry'
						tostring helpme, replace
						replace cntry = "`cname': placebo country " + helpme + " [" + cntry +"]" if cntrycode != `cntry'
						drop helpme
						
						* Save
						order cntrycode cntry independence_years bc_lgap*
						sort independence_years
						cd ".\3. Intermediary results\3.4. Intermediaries" 	
						save results_`cntry', replace
						cd ..
						cd ..
						}
					}
				}
			
			
			* Gather all data in one file
			clear all
			cd ".\3. Intermediary results\3.4. Intermediaries" 	
			foreach cntry of global NICs {
				cap append using results_`cntry'
				cap erase results_`cntry'.dta
				}
			sort cntrycode independence_years
			cd ..
			cd ..
			
			* Compute aggregate independence dividend
			preserve
			sum cntrycode if independence_years == 0 &  cntrycode < 400
			local n = `r(N)'
			collapse (mean) bc_lgap [w=popshare] if cntrycode < 400, by(independence_years)
			gen iteration = 0
			gen n = `n'
			tempfile bs
			save `bs', emptyok
			restore
			
			* Bootstrap placebo-estimates
			cd ".\3. Intermediary results\3.4. Intermediaries"
			foreach iteration of numlist 1/$firststepreps {
				noi di `iteration', _continue
				preserve
				gen cntrycode_NIC = cntrycode if cntrycode < 400
				replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
				bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
				collapse (mean) bc_lgap  [w=popshare], by(independence_years)
				gen iteration = `iteration'
				append using `bs', force
				save `bs', replace
				restore
				}
			
			* Get actual and bootstrapped placebo results
			use `bs', clear
			sort iteration independence_years
			cd ..
			cd ..

			* Compute aggregate CI's
			gen PTTDIDD = .
			gen PTTDIDD_ll = .
			gen PTTDIDD_ul = .

			foreach year of numlist -15/30 {
				sum bc_lgap if independence_years == `year' & iteration != 0
				cap replace PTTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
				cap replace PTTDIDD_ll = PTTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & iteration == 0
				cap replace PTTDIDD_ul = PTTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & iteration == 0
				}
				
			* Save results
			keep if iteration == 0
			keep if PTTDIDD != .
			keep independence_years PTTDIDD*
			cd ".\3. Intermediary results"
			order independence_years PTTDIDD
			sort independence_years
			gen robustness_check = `robustness_check'
			save IDD_R`robustness_check', replace
			cd ..
			}

	* STEP 3. Gather & plot results
	
		* Collect baseline & robustness findings
		cd ".\3. Intermediary results"
		use baseline_results, clear
		gen robustness_check = 0
		append using IDD_R1
		append using IDD_R2
		append using IDD_R3
		append using IDD_R4
		
		* Plot robustness check results	
		preserve
		drop if independence_years < -10 | independence_years > 30
		
		twoway 	rline PTTDIDD_ll PTTDIDD_ul independence_years if robustness_check == 3, lstyle(ci) lcolor(gs13) lpattern(solid) || 	///
				connected PTTDIDD independence_years if robustness_check == 3,  mlcolor(gs11) mfcolor(gs13) lcolor(gs13) lpattern(solid) msymbol(Oh) 	||				///
				rline PTTDIDD_ll PTTDIDD_ul independence_years if robustness_check == 2, lstyle(ci) lcolor(gs11) lpattern(dot) || 	///
				connected PTTDIDD independence_years if robustness_check == 2,  mlcolor(gs11) mfcolor(gs11) lcolor(gs11) lpattern(dot) msymbol(T) 	||				///
				rline PTTDIDD_ll PTTDIDD_ul independence_years if robustness_check == 1, lstyle(ci) lcolor(gs8) lpattern("--") || 	///
				connected PTTDIDD independence_years if robustness_check == 1,  mlcolor(gs8) mfcolor(gs8) lcolor(gs8) lpattern("--") msymbol(O) 	||				///
				rline PTDIDD_ll PTDIDD_ul independence_years if robustness_check == 0, lstyle(ci) lcolor(gs0) lpattern("__") || 	///
				connected PTDIDD independence_years if robustness_check == 0,  mlcolor(gs0) mfcolor(gs0) lcolor(gs0) lpattern("__") msymbol(D) msize(medsmall)					///
				yline(0, lpattern(solid) lcolor(gs13)) xline(0, lcolor(red) lp(dot)) ///
				legend(order(8 "Baseline" 6 "Spatial constraint, <2000 km" 4 "Spatial constraint, >4000 km" 2 "Temporal constraint") rows(2)) ytitle("Independence dividend") xtitle("Years of independence", size(large)) title("")	 graphregion(color(white)) bgcolor(white) 	///
				note("with 95% confidence intervals")          ///
				name(rline, replace)
		cd ..
		cd ".\5. TeX results"
		graph export figureA6_1.pdf, replace
		cd ..
		restore

		* Plot robustness check results	
		preserve
		drop if independence_years < -15 | independence_years > 30
							
		twoway 	scatteri .22 -15 .22 -6, bcolor(gs14) recast(area) || ///
				scatteri -.3 -15 -.3 -6, bcolor(gs14) recast(area) || ///
				rline PTTDIDD_ll PTTDIDD_ul independence_years if robustness_check == 4, lstyle(ci) lcolor(gs13) lpattern(solid) || 	///
				connected PTTDIDD independence_years if robustness_check == 4,  mlcolor(gs11) mfcolor(gs13) lcolor(gs13) lpattern(solid) msymbol(Oh) 	||				///
				rline PTDIDD_ll PTDIDD_ul independence_years if robustness_check == 0, lstyle(ci) lcolor(gs0) lpattern("__") || 	///
				connected PTDIDD independence_years if robustness_check == 0,  mlcolor(gs0) mfcolor(gs0) lcolor(gs0) lpattern("__") msymbol(D) msize(medsmall)					///
				yline(0, lpattern(solid) lcolor(gs13)) xline(0, lcolor(red) lp(dot))  xlab(-15(5)30) ///
				legend(order(6 "Baseline" 4 "5-year-forward") rows(1)) ytitle("Independence dividend") xtitle("Years of independence", size(large)) title("")	 graphregion(color(white)) bgcolor(white) 	///
				note("with 95% confidence intervals")          ///
				name(rline, replace)
		cd ".\5. TeX results"
		graph export figureA6_2.pdf, replace
		cd ..
		restore

	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
